   mydir="E:\\_Magnet\\";
-------------------------------------------------------------------------------
-- Definition des Problem-Typs                                               --
-------------------------------------------------------------------------------
   create(0);        -- 0=magnetic|1=electrostatic|2=heatflow|3=currentflow
-- mi_probdef(frequency,units,type,precision,(depth),(minangle))
   mi_probdef(0,"millimeters","axi",1e-8,0,30);
                     -- 1e-8=Max.Fehler fr Solver
                     -- 30 =Min.Winkel fr Netz
-------------------------------------------------------------------------------
-- Numerische Parameter zur Steuerung der Simulationsgenauigkeit             --
-------------------------------------------------------------------------------
   nLuft=1;                     -- Zahl von Elementlagen in kleinen Luftspalten
-------------------------------------------------------------------------------
-- Konstruktive, technologische und Betriebs-Parameter (Standardwerte)       --
-------------------------------------------------------------------------------
-- dMagnet=40;                  -- Topf-Durchmesser [mm]
-- hTopf=27.5;                  -- Topf-Hhe [mm]
-- dAnker=10;                   -- Anker-Durchmesser [mm]
-- lAnker=10;                   -- Anker-Lnge [mm]
-- hDeckel=2.5;                 -- Hhe des Deckels bzw. Topfbodens [mm]
-- dStift=1;                    -- Durchmesser der Bohrung [mm]
-- dWand=1;                     -- Wandstrke des Topfes [mm]
-- wSpule=400;                  -- Windungen in der Spule
-- dLack=0.06;                  -- Gesamtdicke der Drahtbeschichtung [mm]
-- sWickel=0.5;                 -- Spalt zw. Spulendraht und Eisen [mm]
-- sAnker=1;                    -- Arbeitsluftspalt [mm]
-- sDeckel=0.01;                -- Restspalt zw. Deckel und Topf [mm]
-- sGleit=0.1;                  -- Fhrungsluftspalt fr Anker [mm]  
-- iSpule=1;                    -- Spulenstrom [A]
-- Parameter aus Textdatei einlesen mit Fehlertest
   in = openfile(mydir .. "Eingabe.txt","r"); -- Datei ffnen zum Lesen
   if in then -- wenn Datei geffnet, dann Werte einlesen
   read(in, "*l");   dMagnet = read(in, "*l", "*n");
   read(in, "*l");   hTopf = read(in, "*l", "*n");
   read(in, "*l");   dAnker = read(in, "*l", "*n");
   read(in, "*l");   lAnker = read(in, "*l", "*n");
   read(in, "*l");   hDeckel = read(in, "*l", "*n");
   read(in, "*l");   dStift = read(in, "*l", "*n");
   read(in, "*l");   dWand = read(in, "*l", "*n");
   read(in, "*l");   wSpule = read(in, "*l", "*n");
   read(in, "*l");   dLack = read(in, "*l", "*n");
   read(in, "*l");   sWickel = read(in, "*l", "*n");
   read(in, "*l");   sAnker = read(in, "*l", "*n");
   read(in, "*l");   sDeckel = read(in, "*l", "*n");
   read(in, "*l");   sGleit = read(in, "*l", "*n");
   read(in, "*l");   iSpule = read(in, "*l", "*n");
   else print("Could not open Eingabe.txt"); end;
   closefile(in);
-------------------------------------------------------------------------------
-- Unzulssige Eingabe-Parameter von OptiY begrenzen                         --
-------------------------------------------------------------------------------
   if 1*sAnker  < 0.03  then sAnker=0.03;  end;
   if 1*sAnker  > 5     then sAnker=5;     end;
   if 1*sGleit  < 0.05  then sGleit=0.05;  end;
   if 1*sGleit  > 1     then sGleit=1;     end;
   if 1*sDeckel < 0.01  then sDeckel=0.01; end;
   if 1*sDeckel > 1     then sDeckel=1;    end;
   if 1*iSpule  <=1E-10 then iSpule=1E-10; end; -- damit R und L berechenbar!
    
-------------------------------------------------------------------------------
-- Materialien (Luft, Kupfer, Eisen)                                         --
-------------------------------------------------------------------------------
-- mux, muy     : rel. Permeabiltaet in x- bzw. y-Richtung (hier r bzw. z)
-- Hc           : Koerzitivfeldstrke [A/m] -> hier Null
-- J            : aktuelle Stromdichte [A/mm] -> hier Null
-- Cduct        : spez. Leitfhigkeit [MS/m] -> nur bei Kupferdraht
-- LamD         : Schichtdicke [mm] -> falls Laminat-Type<>0
-- PhiHmax      : Hysterese-Verlustwinkel [deg] -> genutzt fr BH-Kurve
-- LamFill      : Material-Fllgrad des Volumens -> 1=komplett gefllt
-- LamTyp       : Laminierungstype, z.B. 0=massiv oder in Ebene / 3=Magnetspule
-- PhiHx, PhiHy : Hysterese-Verlustwinkel [deg] -> genutzt fr =konst.
-- nStr         : Zahl der Einzeldrhte in Spule -> 1 in der Magnetspule
-- dWire        : Durchmesser Cu im Spulendraht [mm]
   bSpule       = 0.5*(dMagnet-dAnker)-dWand-2*sWickel; -- Breite Wickelfenster
   hSpule       = hTopf-hDeckel-2*sWickel;              -- Hhe Wickelfenster
   dWire        = sqrt(hSpule*bSpule/wSpule)-dLack;
   mue          = 400;
-- mi_addmaterial(name ,mux,muy,Hc,J,Cduct,LamD,PhiHmax,LamFill,LamTyp,PhiHx,PhiHy,nStr,dWire);
   mi_addmaterial("Luft" ,  1,  1, 0,0,    0,   0,      0,      1,     0,    0,    0,   0,  0  );
   mi_addmaterial("Draht",  1,  1, 0,0,   58,   0,      0,      1,     3,    0,    0,   1,dWire);
   mi_addmaterial("Stahl",mue,mue, 0,0,    0,   0,      0,      1,     0,    0,    0,   0,  0  );

-- B-H-Kennlinie Stahl (Vielzahl der Ziffern aus Umrechnung der (B)-Funktion)
   mi_addbhpoint("Stahl", 0       ,      0      );
   mi_addbhpoint("Stahl", 0.2004  ,    318.31   );
   mi_addbhpoint("Stahl", 0.6008  ,    636.62   );
   mi_addbhpoint("Stahl", 1.102   ,   1591.55   );
   mi_addbhpoint("Stahl", 1.386   ,   4774.65   );
   mi_addbhpoint("Stahl", 1.465   ,   7957.75   );
   mi_addbhpoint("Stahl", 1.667548,  32902.23251);
   mi_addbhpoint("Stahl", 1.789509,  92585.3973 );
   mi_addbhpoint("Stahl", 1.878209, 160685.3549 );
   mi_addbhpoint("Stahl", 2.08 , 318310 );
-------------------------------------------------------------------------------
-- Circuit Property fr die Wicklung definieren (Strom und Wicklungstyp      --
-------------------------------------------------------------------------------
-- mi_addcircprop("circuitname", i, type) i: Strom / type: 0=parallel 1=seriell
   mi_addcircprop("Spule", iSpule, 1);
-------------------------------------------------------------------------------
-- Geometrie (Zylinder-Koordinaten mit r,z: alle Abmessungen in mm!)         --
-- Blocklabels in alle Geometriebereiche und Zuweisen der Materialien        --
-------------------------------------------------------------------------------
                               -- *********************************************
   mi_seteditmode ("nodes");   -- K=Kugelsphre *******************************
                               -- *********************************************
   rKugel=dMagnet+hTopf+hDeckel;
   rK00= 0;           zK00= 0;           mi_addnode (rK00,zK00); --Ursprung 0,0
   rK01= 0;           zK01= rKugel;      mi_addnode (rK01,zK01); --Oben
   rK02= 0;           zK02=-rKugel;      mi_addnode (rK02,zK02); --Unten
   mi_zoomnatural(); mi_zoomout();            -- Zoom incl. Achse im Bild 
   mi_seteditmode ("arcsegments");
-- mi_addarc(  r1,z1   ,   r2,z2   ,angle, maxseg deg.);
   mi_addarc(rK02,zK02 , rK01,zK01 , 180 , 5) -- Halbkreis entgegen Uhrzeiger
   mi_seteditmode ("segments");               -- Symmetrieachse im Halbkreis
   mi_addsegment  ( rK01,zK01 , rK02,zK02 );  -------------------------------
   mi_seteditmode ("blocks");                 -- Blocklabel Luft Automesh=1--
   r0_K=0.9*rKugel;              z0_K=0;      -- 10% vom rechten Rand      --
   mi_addblocklabel(r0_K, z0_K); mi_selectlabel(r0_K,z0_K);
   mi_setblockprop("Luft",1,0,"<None>",0,0,0); mi_clearselected();
-- mi_setblockprop("name",automesh,meshsize,"incircuit",magdir,group,turns);

                               -- *********************************************
   mi_seteditmode  ("nodes");  -- S=Spulen-Wickelfenster **********************
                               -- *********************************************
   rS01= dAnker/2+sWickel; zS01= hSpule/2;               mi_addnode(rS01,zS01);
   rS02= rS01+bSpule;     zS02= zS01;                    mi_addnode(rS02,zS02);
   rS03= rS02;            zS03=-hSpule/2;                mi_addnode(rS03,zS03);
   rS04= rS01;            zS04= zS03;                    mi_addnode(rS04,zS04);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rS01,zS01 , rS02,zS02 );
   mi_addsegment   ( rS02,zS02 , rS03,zS03 );
   mi_addsegment   ( rS03,zS03 , rS04,zS04 );
   mi_addsegment   ( rS04,zS04 , rS01,zS01 );    ------------------------------
   mi_seteditmode  ("blocks");                   -- Block "Draht" als "Spule"--
   r0_S=rS01+(rS02-rS01)/2; z0_S=zS04+(zS01-zS04)/2;-- in Mitte Wickelfenster--
   mi_addblocklabel(r0_S, z0_S);                     mi_selectlabel(r0_S,z0_S);
   mi_setblockprop ("Draht",1,0,"Spule",0,0,wSpule); mi_clearselected();
   
                               -- *********************************************
   mi_seteditmode  ("nodes");  -- T=Eisenkreis (Topf) *************************
                               -- *********************************************
   rT01= dStift/2;       zT01= (hTopf+hDeckel)/2-lAnker; mi_addnode(rT01,zT01);
   rT02= dAnker/2;       zT02= zT01;                     mi_addnode(rT02,zT02);
   rT03= rT02;           zT03=-(hTopf-hDeckel)/2;        mi_addnode(rT03,zT03);
   rT04= dMagnet/2-dWand;zT04= zT03;                     mi_addnode(rT04,zT04);
   rT05= rT04;           zT05=-zT04;                     mi_addnode(rT05,zT05);
   rT06= dMagnet/2;      zT06= zT05;                     mi_addnode(rT06,zT06);
   rT07= rT06;           zT07=-(hTopf+hDeckel)/2;        mi_addnode(rT07,zT07);
   rT08= rT01;           zT08= zT07;                     mi_addnode(rT08,zT08);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rT01,zT01  , rT02,zT02 );
   mi_addsegment   ( rT02,zT02  , rT03,zT03 );
   mi_addsegment   ( rT03,zT03  , rT04,zT04 );
   mi_addsegment   ( rT04,zT04  , rT05,zT05 );
   mi_addsegment   ( rT05,zT05  , rT06,zT06 );
   mi_addsegment   ( rT06,zT06  , rT07,zT07 );
   mi_addsegment   ( rT07,zT07  , rT08,zT08 );
   mi_addsegment   ( rT08,zT08  , rT01,zT01 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Stahl" in Topfmitte  --
   r0_T=rT01+(rT02-rT01)/2;    z0_T=zT03+(zT02-zT03)/2;
   mi_addblocklabel(r0_T, z0_T);                     mi_selectlabel(r0_T,z0_T);
   mi_setblockprop ("Stahl",1,0,"<None>",0,0,0);     mi_clearselected();
   
                               -- *********************************************
   mi_seteditmode  ("nodes");  -- A=Eisenkreis (Anker) ************************
                               -- *********************************************
   rA01= dStift/2;        zA01= zT01+sAnker+lAnker;      mi_addnode(rA01,zA01);
   rA02= dAnker/2;        zA02= zA01;                    mi_addnode(rA02,zA02);
   rA03= rA02;            zA03= zT01+sAnker;             mi_addnode(rA03,zA03);
   rA04= rA01;            zA04= zA03;                    mi_addnode(rA04,zA04);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rA01,zA01  , rA02,zA02 );
   mi_addsegment   ( rA02,zA02  , rA03,zA03 );
   mi_addsegment   ( rA03,zA03  , rA04,zA04 );
   mi_addsegment   ( rA04,zA04  , rA01,zA01 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Stahl" in Ankermitte --
   r0_A=rA01+(rA02-rA01)/2;    z0_A=zA03+(zA02-zA03)/2;   
   mi_addblocklabel(r0_A, z0_A);                     mi_selectlabel(r0_A,z0_A);
   mi_setblockprop ("Stahl",1,0,"<None>",0,1,0);     mi_clearselected();

                               -- *********************************************
   mi_seteditmode ("nodes");   -- D=Eisenkreis (Deckel) ***********************
                               -- *********************************************
   rD01= dAnker/2+sGleit; zD01= zT06+sDeckel+hDeckel;    mi_addnode(rD01,zD01);
   rD02= dMagnet/2;       zD02= zD01;                    mi_addnode(rD02,zD02);
   rD03= rD02;            zD03= zD01-hDeckel;            mi_addnode(rD03,zD03);
   rD04= rD01;            zD04= zD03;                    mi_addnode(rD04,zD04);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rD01,zD01  , rD02,zD02 );
   mi_addsegment   ( rD02,zD02  , rD03,zD03 );
   mi_addsegment   ( rD03,zD03  , rD04,zD04 );
   mi_addsegment   ( rD04,zD04  , rD01,zD01 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Stahl" in Deckelmitte--
   r0_D=rD01+(rD02-rD01)/2;    z0_D=zD03+(zD02-zD03)/2;  
   mi_addblocklabel(r0_D, z0_D);                     mi_selectlabel(r0_D,z0_D);
   mi_setblockprop ("Stahl",1,0,"<None>",0,0,0);     mi_clearselected();
                               -- *********************************************
   mi_seteditmode ("segments");-- L=Arbeitsluftspalt (Topf/Anker) *************
                               -- *********************************************
   mi_addsegment   ( rA04,zA04  , rT01,zT01 );
   mi_addsegment   ( rA03,zA03  , rT02,zT02 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Luft" in Spaltmitte  --
   r0_L=rA04+(rA03-rA04)/2;    z0_L=zT01+(zA04-zT01)/2;
   mi_addblocklabel(r0_L, z0_L);                     mi_selectlabel(r0_L,z0_L);
   mi_setblockprop ("Luft",0,sAnker/nLuft,"<None>",0,0,0);  mi_clearselected();
                               -- *********************************************
   mi_seteditmode  ("nodes");  -- R=Restspalt (Deckel/Topf) *******************
                               -- *********************************************
   rD05= rT05;            zD05= zD03;                    mi_addnode(rD05,zD05);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rD05,zD05  , rT05,zT05 );
   mi_addsegment   ( rD03,zD03  , rT06,zT06 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Luft" in Spaltmitte  --
   r0_R=rD05+(rD03-rD05)/2;    z0_R=zT05+(zD05-zT05)/2; 
   mi_addblocklabel(r0_R, z0_R);                     mi_selectlabel(r0_R,z0_R);
   mi_setblockprop ("Luft",0,sDeckel/nLuft,"<None>",0,0,0); mi_clearselected();
                               -- *********************************************
   mi_seteditmode  ("nodes");  -- F=Fhrungsspalt (Deckel/Anker) **************
                               -- *********************************************
   rA05= rD01-sGleit;     zA05= zD01;                    mi_addnode(rA05,zA05);
   rA06= rA05;            zA06= zD04;                    mi_addnode(rA06,zA06);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rA05,zA05  , rD01,zD01 );
   mi_addsegment   ( rA06,zA06  , rD04,zD04 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Luft" in Spaltmitte  --
   r0_F=rA05+(rD01-rA05)/2;    z0_F=zA06+(zA05-zA06)/2;
   mi_addblocklabel(r0_F, z0_F);                      mi_selectlabel(r0_F,z0_F);
   mi_setblockprop ("Luft",0,sGleit/nLuft,"<None>",0,0,0);   mi_clearselected();

                               -- *********************************************
   mi_seteditmode  ("nodes");  -- B=Bohrung ***********************************
                               -- *********************************************
   rB01= 0;               zB01= zA01;                    mi_addnode(rB01,zB01);
   rB02= 0;               zB02= zT08;                    mi_addnode(rB02,zB02);
   mi_seteditmode  ("segments");
   mi_addsegment   ( rB01,zB01  , rA01,zA01 );
   mi_addsegment   ( rB02,zB02  , rT08,zT08 );---------------------------------
   mi_seteditmode  ("blocks");                -- Block "Luft" in Bereichsmitte-  
   r0_B=rA01/2;                z0_B=0; 
   mi_addblocklabel(r0_B, z0_B);                     mi_selectlabel(r0_B,z0_B);
   mi_setblockprop ("Luft",0,dStift/2/nLuft,"<None>",0,0,0);mi_clearselected();
                               -- *********************************************
   mi_seteditmode  ("blocks"); -- W=Wickelspalt *******************************
                               -- *********************************************
   r0_W=rT03+(rS04-rT03)/2;    z0_W=zS04+(zS01-zS04)/2; --> Mitte innerer Spalt
   mi_addblocklabel(r0_W, z0_W);                     mi_selectlabel(r0_W,z0_W);
   mi_setblockprop("Luft",0,sWickel/nLuft,"<None>",0,0,0);  mi_clearselected();
-------------------------------------------------------------------------------
-- Randbedingungen fr die Kugelsphre als "Mixed Open Boundary Conditions"  --
-------------------------------------------------------------------------------
-- mi_addboundprop("name", A0, A1, A2, Phi, Mu, Sig, c0, c1, BdryFormat);
-- BC-Type Mixed: DdryFormat=2, c0 und c1 wie berechnet, alle anderen Parm=0
   c0=1/(uo*rKugel*mm); c1=0; 
   mi_addboundprop("RobinBC", 0, 0, 0, 0, 0, 0, c0, c1, 2);
   mi_seteditmode ("arcsegments");
-- mi_selectarcsegment (  r   ,z); -- Select the arc segment closest to (r,z)
   mi_selectarcsegment (rKugel,0); --> Mittelpunkt des Bogens
-- mi_setarcsegmentprop(maxsegdeg,"propname",hide,group);
   mi_setarcsegmentprop(   3     ,"RobinBC" ,  0 ,  0  );
   mi_clearselected();
-------------------------------------------------------------------------------
-- Vernetzung und Feld-Berechnung  (nach Speichern des Modells)              --
-------------------------------------------------------------------------------
   mi_saveas(mydir .. "Magnet.fem"); -- Speichern in vorh. Ordner
   mi_createmesh();    -- Erzeugen des Netzes
   mi_seteditmode("group");
   mi_selectgroup(1);
   mi_analyze(0);      -- Solverfenster 0=minimiert / 1=sichtbar
   mi_loadsolution();  -- ffnet Ergebnisfenster fr Postprozess
-------------------------------------------------------------------------------
-- Beginn des Postprozesses                                                               --
-------------------------------------------------------------------------------
-- Kontrollausgabe auf der LUA-Console:
   showconsole();                  -- LUA-Console ffnen, falls nicht offen
   mo_zoom(0,-rKugel/3,rKugel/3,rKugel/3); -- Rechteck um Magnet in Kugelsphre
   mo_showcontourplot (-1); -- Feldlinien normiert auf Bereich (lt.Preferences)
-- mo_showdensityplot(legend,gscale,upper_B,lower_B,type);
   mo_showdensityplot(   1  ,   0  ,   1   ,    0  ,"bmag");
   mo_seteditmode("areas");
   mo_groupselectblock(1);         -- Auswahl Anker-Block -> Group=1 bei Def.!
   Fz_Anker=mo_blockintegral(19);  -- (19): z-Komponente der statischen Kraft
   print ("F=", Fz_Anker,  "[N]")  -- Kraft in Outputfeld der LUA-Cosole
   iSpule, vOhm, Psi = mo_getcircuitproperties("Spule"); -- statische Gren
   print ("i=", iSpule   , "[A]"); -- Strom
   print ("w=", wSpule   , "[-]"); -- Windungszahl
   print ("v=", vOhm     , "[V]"); -- Spannungsabfall
   print ("R=",vOhm/iSpule,"[Ohm]"); -- Drahtwiderstand
   print ("L=",Psi/iSpule ,"[H]"); -- Induktivitt
   print ("Psi=", Psi    , "[Wb]");-- Koppelfluss
   
-- Output-File mit Ergebniswerten erzeugen:   
   out = openfile(mydir .. "Ergebnis.txt", "w");
   write (out,"F="  , Fz_Anker, "\n");
   write (out,"Psi=", Psi     , "\n");
   closefile(out);
-- exit();      