Public iReturn As Integer
Public FirstTempLoadset As Integer

	Sub Main
	Dim App As femap.model
	Set App = feFemap()
	Dim rc As femap.zReturnCode


	Dim BCSet As Object			'Constraint Set
	Set BCSet = App.feBCSet

	Dim BC As Object
	Set BC = App.feBCNode	' Constraints On Nodes

	Dim LdSet As Object			'Load Set
	Set LdSet = App.feLoadSet

	Dim Ld As Object				'Mesh-bezogene Last
	Set Ld = App.feLoadMesh

	Dim LdGeom As Object				'Geometrie-bezogene Last
	Set LdGeom = App.feLoadGeom

	Dim Nt As Object			'Temperaturvorgaben an Knoten
	Set Nt = App.feLoadNTemp

	Dim Et As Object			'Temperaturvorgaben an Elementen
	Set Et = App.feLoadETemp

	Dim strActiveConstraintSet As String
	Dim nConstraintSet As Integer

	Dim IsStatic As Boolean 	  'Mechanik-Lastfall
	Dim IsTemp As Boolean 		'Temperatur-Lastfall

	FirstTempLoadset=0
	Dim strFirstTempLoadSet As String
	Dim nLoadSet As Integer
	Dim nLoadSetTemp As Integer
	Dim nLoadSetStatic As Integer
	nLoadSet=0
	nLoadSetTemp=0
	nLoadSetStatic=0

	strActiveConstraintSet=""
	While (BCSet.Next())		'Schleife ber Constraint-Sets
		If BCSet.Active=BCSet.ID Then
			strActiveConstraintSet="aktives Constraint-Set : " & BCSet.ID & " """ & BCSet.title & """"
		End If
	Wend
	If strActiveConstraintSet="" Then
		App.feAppMessage(3,"keinen bzw. keinen aktivierten Constraint-Set gefunden!  Start Means-Solver ist sinnlos!")
		Beep:	Exit Sub
	End If

	While (LdSet.Next())		'Schleife ber Lastflle (Load-Sets)
		IsStatic=False
		IsTemp=False
		IsTransient=False

    	Ld.SetID = LdSet.ID

	 	If LdSet.BodyAccelOn Then IsStatic=True		'Body-Load Beschleunigung
	 	If LdSet.BodyVelocityOn Then IsStatic=True	'Body-Load Drehung

		Ld.ID = -1
   		While (Ld.Next())				'Schleife ber Mesh-bezogene Lasten

			If Ld.type=1 Then
				IsStatic=True				'Knotenlast Kraft
			ElseIf Ld.type=2 Then
				IsStatic=True				'Knotenlast Moment
			ElseIf Ld.type=3 Then
				IsStatic=True				'Constraint vorgegebene Verschiebung
			ElseIf Ld.type=4 Then
				IsStatic=True				'Constraint vorgegebene Verdrehung
			ElseIf Ld.type=10 Then
				IsTemp=True					'Knotenfluss (Wrmestrom)
			ElseIf Ld.type=11 Then
				IsTemp=True					'Knotenfluss (Wrmegeneration)
			ElseIf Ld.type=42 Then
				IsStatic=True				  'Druck auf Flche
			ElseIf Ld.type=44 Then
				IsTemp=True				 	'Wrmestromdichte = Flchenquelle
			ElseIf Ld.type=45 Then
				IsTemp=True				 	'Konvektion
			ElseIf Ld.type=47 Then
				IsTemp=True				 	'Volumenquelle
			Else
				App.feAppMessage(3,"Lastfall " & LdSet.ID _
				& ": Fr Means unbekannte netzbezogene Belastung gefunden: " & Ld.type _
				& vbCrLf & " see FEMAP.Help 5.30.3 LoadMesh Load Types")
				Beep:	Exit Sub

				'5.30.3 LoadMesh Load Types
				'The following table provides the list of available load types On nodes And elements.
				'1  nForce  11  nHeatGen  20  nSlipCondition
				'2  nMoment  12  Transient  21  nFanCurve
				'3  nDisplacement  13  nPressure  22  nPeriodic
				'4  nRotDisplacement  14  nTotalPressure  41  eLineLoad
				'5  nVelocity  15  nScalar  42  ePressure
				'6  nRotVelocity  16  nSteamQuality  44  eHeatFlux
				'7  nAcceleration  17  nHumidity  45  eConvection
				'8  nRotAcceleration  18  nFluidHeight  46  eRadiation
				'10  nHeatFlux  19  nUnknownCondition  47  eHeatGen
			End If
    	Wend

		LdGeom.ID = -1
   		While (LdGeom.Next())				'Schleife ber geometrie-bezogene Lasten

			If LdGeom.type=81 Then
				IsStatic=True				'Punktlast Kraft	--> expand to Node
			ElseIf LdGeom.type=82 Then
				IsStatic=True				'Punktlast Moment --> expand to Node
			ElseIf LdGeom.type=83 Then
				IsStatic=True				'Constraint vorgegebene Verschiebung	--> expand to Node
			ElseIf LdGeom.type=84 Then
				IsStatic=True				'Constraint vorgegebene Verdrehung	--> expand to Node
			ElseIf LdGeom.type=89 Then
				IsTemp=True				'Temperaturvorgabe an Punkt	--> expand to Node
			ElseIf LdGeom.type=90 Then
				IsTemp=True					'Punktfluss (Wrmestrom)	--> expand to Node
			ElseIf LdGeom.type=91 Then
				IsTemp=True					'Punktfluss (Wrmegeneration)	--> expand to Node
			ElseIf LdGeom.type=121 Then
				IsStatic=True				'Linienlast Kraft	--> expand to Nodes
			ElseIf LdGeom.type=122 Then
				IsStatic=True				'Linienlast Kraft/Lnge	--> expand to Nodes
			ElseIf LdGeom.type=123 Then
				IsStatic=True				'Linienlast Kraft pro Knoten	--> expand to Nodes
			ElseIf LdGeom.type=124 Then
				IsStatic=True				'Linienlast Moment	--> expand to Nodes
			ElseIf LdGeom.type=125 Then
				IsStatic=True				'Linienlast Moment/Lnge	--> expand to Nodes
			ElseIf LdGeom.type=126 Then
				IsStatic=True				'Linienlast Moment pro Knoten	--> expand to Nodes
			ElseIf LdGeom.type=127 Then
				IsStatic=True				'Linie: Constraint vorgegebene Verschiebung	--> expand to Nodes
			ElseIf LdGeom.type=128 Then
				IsStatic=True				'Linie: Constraint vorgegebene Verdrehung	--> expand to Nodes
			ElseIf LdGeom.type=133 Then
				IsTemp=True				'Temperaturvorgabe an Linie	--> expand to Nodes
			ElseIf LdGeom.type=134 Then
				IsTemp=True					'Linie: Wrmestrom	--> expand to Nodes
			ElseIf LdGeom.type=135 Then
				IsTemp=True					'Linie: Wrmestrom/Lnge)	--> expand to Nodes
			ElseIf LdGeom.type=136 Then
				IsTemp=True					'Linie: Wrmestrom pro Knoten)	--> expand to Nodes
			ElseIf LdGeom.type=137 Then
				IsTemp=True					'Linie: Wrmegeneration	--> expand to Nodes
			ElseIf LdGeom.type=161 Then
				IsStatic=True					'Flche: Kraft 	--> expand to Nodes
			ElseIf LdGeom.type=162 Then
				IsStatic=True					'Flche: Kraft/Flche	--> expand to Nodes
			ElseIf LdGeom.type=163 Then
				IsStatic=True					'Flche: Kraft pro Knoten	--> expand to Nodes
			ElseIf LdGeom.type=164 Then
				IsStatic=True					'Flche: Moment 	--> expand to Nodes
			ElseIf LdGeom.type=165 Then
				IsStatic=True					'Flche: Moment/Flche	--> expand to Nodes
			ElseIf LdGeom.type=166 Then
				IsStatic=True					'Flche: Moment pro Knoten	--> expand to Nodes
			ElseIf LdGeom.type=167 Then
				IsStatic=True					'Flche: vorgegebene Verschiebung	--> expand to Nodes
			ElseIf LdGeom.type=168 Then
				IsStatic=True					'Flche: vorgegebene Verdrehung	--> expand to Nodes
			ElseIf LdGeom.type=173 Then
				IsTemp=True					'Flche: vorgegebene Temperatur	--> expand to Nodes
			ElseIf LdGeom.type=174 Then
				IsTemp=True					'Flche: Wrmefluss	--> expand to Nodes
			ElseIf LdGeom.type=175 Then
				IsTemp=True					'Flche: Wrmefluss/Flche	--> expand to Nodes
			ElseIf LdGeom.type=176 Then
				IsTemp=True					'Flche: Wrmefluss pro Knoten	--> expand to Nodes
			ElseIf LdGeom.type=177 Then
				IsTemp=True					'Flche: Wrmegeneration	--> expand to Nodes
			ElseIf LdGeom.type=178 Then
				IsStatic=True					'Flche: Druck	--> expand to Element-Sides
			ElseIf LdGeom.type=180 Then
				IsStatic=True					'Flche: Wrmestrom	--> expand to Element-Sides
			ElseIf LdGeom.type=181 Then
				IsTemp=True					'Flche: Konvektion	--> expand to Element-Sides
			ElseIf LdGeom.type=183 Then
				IsTemp=True					'Flche: Wrmegeneration	--> expand to Element-Sides
			Else
				App.feAppMessage(3,"Lastfall " & LdSet.ID _
				& ": Fr Means unbekannte geometriebezogene Belastung gefunden: " & Ld.type _
				& vbCrLf & " see FEMAP.Help 5.29.3 LoadGeom Load Types")
				Beep:	Exit Sub

				'Geometry Load Types (p = Point ; c = Curve ; s = Surface, n=on Node, e=on Element)
				' 81  pnForce  							129  cnVelocity  165  snMomentPerArea
				' 82  pnMoment   					130  cnRotVelocity  166  snMomentAtNode
				' 83  pnDisp  			 				131  cnAccel  167  snDisp
				' 84  pnRotDisp  	  				132  cnRotAccel  168  snRotDisp
				' 85  pnVelocity  	   				133  cnTemp  169  snVelocity
				' 86  pnRotVelocity  				134  cnHeatFlux  170  snRotVelocity
				' 87  pnAccel  							135  cnHeatFluxPerLength  171  snAccel
				' 88  pnRotAccel  						136  cnHeatFluxAtNode  172  snRotAccel
				' 89  pnTemp  						137  cnHeatGen  173  snTemp
				' 90  pnHeatFlux  					138  cePressure  174  snHeatFlux
				' 91  pnHeatGen  				139  ceTemp  175  snHeatFluxPerArea
				' 92  pnPressure  				140  ceHeatFlux  176  snHeatFluxAtNode
				' 93  pnTotalPressure  		141  ceConvection  177  snHeatGen
				' 94  pnScalar  				142  ceRadiation  178  sePressure
				' 95  pnSteamQuality  		143  ceHeatGen  179  seTemp
				' 96  pnHumidity 			 	144  cnPressure  180  seHeatFlux
				' 97  pnFluidHeight  			 145  cnTotalPressure  181  seConvection
				' 98  pnUnknownCondition  146  cnScalar  182  seRadiation
				' 99  pnSlipCondition  			147  cnSteamQuality  183  seHeatGen
				'100  pnFanCurve  			   148  cnHumidity  184  snPressure
				'101  pnPeriodic 				  149  cnFluidHeight  185  snTotalPressure
				'121  cnForce  					  150  cnUnknownCondition  186  snScalar
				'122  cnForcePerLength  	151  cnSlipCondition  187  snSteamQuality
				'123  cnForceAtNode  		152  cnFanCurve  188  snHumidity
				'124  cnMoment  				153  cnPeriodic  189  snFluidHeight
				'125  cnMomentPerLength  161  snForce  190  snUnknownCondition
				'126  cnMomentAtNode  		162  snForcePerArea  191  snSlipCondition
				'127  cnDisp  						163  snForceAtNode  192  snFanCurve
				'128  cnRotDisp  					164  snMoment  193  snPeriodic
			End If
    	Wend

		Et.SetID = LdSet.ID		'Elementbezogene Lasten
    	Et.ID = -1
    	While (Et.Next())
			App.feAppMessage(3,"Lastfall " & LdSet.ID & ": Temperaturvorgaben fr Element von Means nicht untersttzt!" _
    		& vbCrLf & "(Temperaturvorgaben fr Knoten verwenden)")
			Beep:	Exit Sub
    	Wend

    	Nt.SetID = LdSet.ID
 	   	Nt.ID = -1
    	While (Nt.Next())
     		IsTemp=True			 	'Knotenbezogene Temperaturvorgaben
   	 	Wend

 		If IsStatic Then
			'Debug.Print  "Lastfall ";Ld.SetID;" "; LdSet.title;" ist Mechanik-Lastfall"
			nLoadSetStatic=nLoadSetStatic+1
		End If
		If IsTemp Then
			'Debug.Print  "Lastfall ";Ld.SetID;" "; LdSet.title;" ist Temperatur-Lastfall"
			If FirstTempLoadset=0 Then
				FirstTempLoadset=Ld.SetID
				strFirstTempLoadSet=LdSet.title
			End If
			nLoadSetTemp=nLoadSetTemp+1
		End If
		nLoadSet=nLoadSet+1

 	Wend								'Ende Schleife ber Lastflle


	Dim DescText As String
 	If FirstTempLoadset=0 Then
		DescText="kein Temperaturlastfall gefunden"
    Else
    	DescText=	"fr Lastfall " & FirstTempLoadset & ": """ & strFirstTempLoadSet & """" & vbCrLf & "(erster gefundener Temperaturlastfall)"
    End If

    Dim TextnLoadSet As String
    Dim TextnLoadSetStatic As String
    Dim TextnLoadSetTemp As String
    If nLoadSet=0 Then
    		App.feAppMessage(3,"keine Lastflle gefunden! Start Means-Solver ist sinnlos!")
			Beep:	Exit Sub
   	Else
    	TextnLoadSet=nLoadSet & " Lastflle zu berechnen"
    	If nLoadSetStatic=0 Then
    		TextnLoadSetStatic="keine Statik- Lastflle gefunden"
    	ElseIf nLoadSetStatic=1 Then
    		TextnLoadSetStatic=nLoadSetStatic & " Statik-Lastfall zu berechnen"
    	Else
    		TextnLoadSetStatic=nLoadSetStatic & " Statik-Lastflle zu berechnen"
    	End If
    	If nLoadSetTemp=0 Then
    		TextnLoadSetTemp="keine Temperatur-Lastflle gefunden"
    	ElseIf nLoadSetTemp=1 Then
    		TextnLoadSetTemp=nLoadSetTemp & " Temperatur-Lastfall zu berechnen"
    	Else
    		TextnLoadSetTemp=nLoadSetTemp & " Temperatur-Lastflle zu berechnen"
    	End If
    End If



	Rem Dialog erzeugen
	Begin Dialog MeansDialog 640,371,"Steuerung Means-Solver",.DialogFunc ' %GRID:10,7,1,1

	    Rem !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		Rem Reihenfolge nicht ndern! (wird in Dialogfunc bentigt!)

		CheckBox 10,56,280,14,"Mittenknoten erzeugen",.MidnodesCheck

		CheckBox 300,56,280,14,"transiente Temperaturfeldberechnung",.InstatCheck

		GroupBox 10,77,270,238,"Starttemperatur"
		text 20,98,180,28,"(fr transiente bzw. nichtlineare Berechnungen)"
		TextBox 20,140,90,14,.TempStart
		text 130,140,130,14,"Starttemperatur (C)"

		GroupBox 290,77,340,238,"Zeit-Steuerung fr transiente Berechnung"

		TextBox 300,126,90,14,.TStart
		text 410,126,150,14,"Startzeit (sec)"

		TextBox 300,147,90,14,.TStep
		text 410,147,150,14,"Zeitschrittweite (sec)"
		OptionGroup .Anpassung
			OptionButton 310,168,310,14,"automatische Anpassung der Zeitschrittweite"
			OptionButton 310,182,310,14,"keine automatische Anpassung erlaubt"
			OptionButton 310,196,310,14,"nur automatische Vergrerung erlaubt"

		TextBox 300,217,90,14,.TEnd
		text 410,217,150,14,"Endzeit (sec)"


		OptionGroup .Abbruch
			OptionButton 310,238,310,14,"Rechnung bis Endzeit"
			OptionButton 310,252,310,14,"Rechnung bis eingeschwungener Zustand"
		text 330,266,290,14,"(--> automatische Anpassung Zeitschrittweite)"

		TextBox 310,287,90,14,.Epsilon
		text 420,287,200,14,"Abbruchkriterium (epsilon)"

		PushButton 10,336,140,21,"Cancel"
		PushButton 430,336,200,21,"Save Parameter + Run Solver"

		text 300,98,310,28,DescText
		text 10,7,280,14,TextnLoadSet,.TextnLoadSet
		text 300,7,330,28,strActiveConstraintSet,.strActiveConstraintSet
		text 10,35,290,14,TextnLoadSetStatic,.TextnLoadSet2
		text 300,35,340,14,TextnLoadSetTemp,.TextnLoadSet3
	End Dialog
   	Dim dlg As MeansDialog

	'automatische Erzeugung von Mittenknoten aus Tools/Variables lesen
	Dim iMidNodes As Integer		'0 ohne   1 mit
	Dim rMidNodes As Double
	Dim strEquMidNodes As String
	rc=App.feVarGet("MidNodes",rMidNodes,strEquMidNodes)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then
		iMidNodes=0
	Else
		iMidNodes=rMidNodes
	End If
   	dlg.Midnodescheck=iMidNodes

	'transiente Berechnung aus Tools/Variables lesen
	Dim instat As Integer			'0 stationr   1 instationr
	Dim rInstat As Double
	Dim strEquInstat As String
	rc=App.feVarGet("INSTAT",rInstat,strEquInstat)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then
		instat=0
	Else
		instat=rInstat
	End If
   	dlg.instatcheck=instat

	'Startzeit aus Tools/Variables lesen
	Dim rTstart As Double
	rc=App.feVarGet("tStart",rTstart,dlg.tstart$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then dlg.tstart$="0.0"

	'Zeitschrittweite aus Tools/Variables lesen
	Dim rTstep As Double
	rc=App.feVarGet("tStep",rTstep,dlg.tstep$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then dlg.tstep$="1.0"

	'Endzeit aus Tools/Variables lesen
	Dim rTend As Double
	rc=App.feVarGet("tEnd",rTend,dlg.tend$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then dlg.tend$="99.0"

	'Zeitschrittsteuerung aus Tools/Variables lesen
	Dim iTStep As Integer
	Dim riTstep As Double
	rc=App.feVarGet("indikTStep",riTstep,TStep$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then
		iTStep=0
	Else
		iTStep=riTstep
	End If

	If iTStep=0 Then
		dlg.anpassung=0
		dlg.abbruch=0
    ElseIf iTStep=1 Then
		dlg.anpassung=1
		dlg.abbruch=0
    ElseIf iTStep=2 Then
		dlg.anpassung=2
		dlg.abbruch=0
    ElseIf iTStep=3 Then
		dlg.anpassung=0
		dlg.abbruch=1
    ElseIf iTStep=4 Then
		dlg.anpassung=2
		dlg.abbruch=1
	End If

	'Abbruchkriterium Epsilon aus Tools/Variables lesen
	Dim rEpsilon As Double
	rc=App.feVarGet("Epsilon",rEpsilon,dlg.epsilon$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then dlg.epsilon$="1.0E-6"

	'Start-Temperatur aus Tools/Variables lesen
	Dim rTempStart As Double
	rc=App.feVarGet("TempStart",rTempStart,dlg.tempstart$)
	If rc=femap.FE_NOT_EXIST Or rc=femap.FE_INVALID Then dlg.tempstart$="20.0"


	'Dialog anzeigen
tryagain:
	iReturn=0
   Dialog dlg
   If iReturn = 0 Then
   		Exit Sub
   End If

	'automatische Erzeugung von Mittenknoten in Tools/Variable speichern
	iMidNodes=dlg.MidnodesCheck
	 rMidNodes=iMidNodes
	App.feVarPut("Midnodes",False,True,rMidNodes,"")

	'transiente Berechnung in Tools/Variable speichern
	instat=dlg.Instatcheck
	rInstat=instat
	App.feVarPut("INSTAT",False,True,rInstat,"")

	If instat=1 Then
		'Indikator Zeitschrittweitensteuerung in Tools/Variable speichern
		iTStep=dlg.anpassung
		If dlg.abbruch=1 Then iTStep=iTStep+3
		If iTStep=4 Then
			App.feAppMessage(3,"Zeitschrittsteuerung  korrigiert (Rechnung bis Endzeit erfordert automatische Anpassung)")
			Beep
		End If
		If iTStep=5 Then iTStep=4
 		 riTstep=iTStep
		App.feVarPut("indikTStep",False,True,riTstep,"")

		'Startzeit in Tools/Variable speichern
		On Error GoTo errTStart
		rTstart=	CDbl(Replace$(dlg.tstart$,".",","))
		App.feVarPut("tStart",False,True,rTstart,"")

		'Zeitschrittweite in Tools/Variable speichern
		On Error GoTo errTStep
		rTstep=	CDbl(Replace$(dlg.tstep$,".",","))
		App.feVarPut("tStep",False,True,rTstep,"")

		'Endzeit in Tools/Variable speichern
		On Error GoTo errTEnd
		rTend=	CDbl(Replace$(dlg.tend$,".",","))
		App.feVarPut("tend",False,True,rTend,"")

		If rTstart<0 Then
	   		App.feAppMessage(3,"Startzeit falsch !  (Bedingung: 0 <= Startzeit)")
			Beep:GoTo TryAgain
		End If
		If rTstep<=0 Then
	   		App.feAppMessage(3,"Zeitschrittweite falsch !  (Bedingung: Zeitschrittweite > 0)")
			Beep:GoTo TryAgain
		End If
		If rTend<=0 Then
   			App.feAppMessage(3,"Endzeit falsch !  (Bedingung: Endzeit > 0)")
			Beep:GoTo TryAgain
		End If
		If (rTend-rTstart)/rTstep < 2 Then
   			App.feAppMessage(3,"Konflikt der Zeitschrittweiten   (Bedingung: mindestens 2 Zeitschritte berechnen)")
			Beep:GoTo TryAgain
		End If

		If dlg.abbruch=1 Then
			'Abbruchkriterium in Tools/Variable speichern
			On Error GoTo errEpsilon
			rEpsilon=	CDbl(Replace$(dlg.epsilon$,".",","))
			App.feVarPut("epsilon",False,True,rEpsilon,"")

			If rEpsilon<=0 Then
		   		App.feAppMessage(3,"Abbruchkriterium falsch !  (Bedingung: 0 <= Epsilon)")
				Beep:GoTo TryAgain
			End If
		End If
	End If

	'Starttemperatur in Tools/Variable speichern
	On Error GoTo errTempStart
	rTempStart=	CDbl(Replace$(dlg.tempstart$,".",","))
	App.feVarPut("TempStart",False,True,rTempStart,"")

	'Pfad fr Means aus Installationsverzeichnis von FEMAP
    Dim myExePath As String
    myExePath=   App.ExePath

	'aktueller Filename
    Dim myModelName As String
    myModelName= App.ModelName

   	If myModelName="" Then
    	rc=App.feFileSave(True)
    	myModelName= App.ModelName
  	Else
		rc=App.feFileSave(False)
    End If
    If rc=femap.FE_FAIL Or rc=femap.FE_NO_FILENAME Then
   		App.feAppMessage(3,"Schreiben MOD-File abgebrochen")
   		Exit Sub
    End If

	App.feAppMessage(2,"Model-Name: " & myModelName)

	'Filenamen der Neutral-Files
	Dim myModelNameNeutralOut As String
 	myModelNameNeutralOut=Replace$(myModelName,".MOD",".NEU",1,-1)
	myModelNameNeutralOut=Replace$(myModelNameNeutralOut,".mod",".NEU",1,-1)
	Dim myModelNameNeutralIn As String
	myModelNameNeutralIn=Replace$(myModelNameNeutralOut, _
	".NEU","_Results.NEU",1,-1)

	'Neutral-File schreiben
	rc=App.feFileWriteNeutral2 _
	(0, myModelNameNeutralOut,False, True,False,False,False, _
	False, False, True, True, True, 8, 7.0, 0 )
	If rc=femap.FE_INVALID Or rc=femap.FE_NOT_EXIST Or rc=femap.FE_FAIL Then
   		App.feAppMessage(3,"Fehler bei Schreiben Neutral-File")
   		Exit Sub
	End If


	'Means-Solver starten und auf Beendigung warten (FEMAP blockieren)
   	Dim myExeString As String
   	myExeString=Chr$(34) & myExePath & "Means\means.exe" & Chr$(34) _
   	& " -neu " _
   	& Chr$(34) & myModelNameNeutralOut & Chr$(34) & " " _
   	&Chr$(34)  & myModelNameNeutralIn & Chr$(34)

   	App.feAppMessage(2,"Starte Means-Solver: " & myExeString)
	App.feFileExecute(myExeString,True)

 	'Neutral-File einlesen
	App.feFileReadNeutral2(0, myModelNameNeutralIn, False, False, True, False, False, True, 0 )

	Exit Sub

	'Fehlerbehandlungen
	errTStart:	Beep
   	App.feAppMessage(3,"Lesefehler Startzeit !")
	GoTo TryAgain

	errTStep:	Beep
   	App.feAppMessage(3,"Lesefehler Zeitschrittweite !")
	GoTo TryAgain

	errTEnd:	Beep
   	App.feAppMessage(3,"Lesefehler Endzeit !")
	GoTo TryAgain

	errTempStart:	Beep
   	App.feAppMessage(3,"Lesefehler Starttemperatur !")
	GoTo TryAgain

	errEpsilon:	Beep
   	App.feAppMessage(3,"LesefehlerAbbruchkriterium !")
	GoTo TryAgain

End Sub

Function DialogFunc(DlgItem$, Action%, SuppValue?) As Boolean
    Debug.Print "Action="; Action%
    Select Case Action%
    Case 1 ' Dialog box initialization
 		If FirstTempLoadset=0 Then 'kein Temperaturlastfall vorhanden
		  	DlgEnable 1,False
          	DlgValue 1,0
    	End If
    Case 2 ' Value changing or button pressed
        If DlgItem$ = "SaveParameter" Then 	iReturn=1
    End Select

    'Enable/Disable Zeitsteuerung
    If DlgValue(1)=1 And  FirstTempLoadset>0 Then	'Click-Feld instationr
	   EnableTime(True)
	   Debug.Print "dlgvalue(17)";DlgValue(17)
	    If DlgValue(17)=0 Then			'Radiobutton bis Endzeit
   			DlgEnable 21, False				'Eingabefeld Epsilon
   			DlgEnable 22, False				'Text zum Eingabefeld Epsilon
   		End If
	Else
	   	EnableTime(False)
	End If

End Function

Sub EnableTime(Enable As Boolean)
		Dim i As Integer
		For i=6 To 22
			DlgEnable i, Enable
		Next
End Sub
